package gov.va.med.mhv.mrp.service;

import java.util.List;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalTaskSearchDTO;
import gov.va.med.mhv.mrp.common.dto.MyGoalsExtensionDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskDTO;
import gov.va.med.mhv.mrp.common.dto.MyTaskSearchDTO;

public interface MyGoalsService {
	
	public List<MyGoalDTO> getMyGoalsForUser(Long userProfileId);

	public List<MyGoalDTO> getMyCompletedGoalsForUser(Long userProfileId);

	public MyGoalDTO getMyGoalById(Long userProfileId, Long goalId);
	
	public MyGoalDTO getMyGoalByName(Long userProfileId, String goalName);

	public MyGoalDTO saveMyGoal(MyGoalDTO myGoalDTO);
	
	public Boolean deleteMyGoal(Long userProfileId, Long goalId);
	
	public List<MyTaskDTO> getMyGoalTasksForUser(MyGoalTaskSearchDTO myGoalTaskSearchDTO);
	
	public List<MyTaskDTO> getMyGoalTasksByKeyword (MyGoalTaskSearchDTO myGoalTaskSearchDTO);
	
	public MyGoalsExtensionDTO getMyGoalsExtension(Long goalExtensionId);
	
	public MyGoalsExtensionDTO addMyGoalsExtension(Long goalId, MyGoalsExtensionDTO myGoalsExtensionDTO);

	public Boolean deleteMyGoalsExtension(Long goalExtensionId);
	
	public MyGoalTaskDTO addMyGoalTask(Long goalExtensionId, MyGoalTaskDTO myGoalTaskDTO);

	public Boolean deleteMyGoalTask(Long taskId);
	
	public MyTaskSearchDTO findMyGoalForTask(Long userProfileId, MyTaskSearchDTO myTaskSearchDTO);

}
